/* Motion-based Color Integration DEMOs*/
/* programmed by Junji WATANABE*/
/*2007/1/4*/
/*2007/7/31*/

#include <psychlops.h>
using namespace Psychlops;

void MixDemo();
void SegDemo();
void AmbDemo();

//the Main -------------------------------------------------------------------------------
void psychlops_main() {
	initialize();	
	Procedure exp;
	exp.setDesign(Procedure::DEMO);

	
//*********** !!! To build each demo from source, uncomment one line !!!**
//***********  *********** *********** *********** *********** ***********
//	exp.setProcedure(&MixDemo);
//	exp.setProcedure(&SegDemo);
	exp.setProcedure(&AmbDemo);
//***********  *********** *********** *********** *********** ***********
	

	exp.run();
	}
//--------------------------------------------------------------------------


// Set Global Parameter--------------------------------------------------------------------------
int DW=1024;//Width of Display
int DH=768;//Height of Display
double DFreq=60.0;//FrameRate of Display


// **************** Function for Mix demo
void MixDemo(){
	//independent-------------------------------
	Range rng;
	int Stype=1; Independent<<Stype |"Stimulus Type"| 1<=rng<=3 | 1 | 1 ;
	int Mode=0; Independent<<Mode |"Mode"| 0<=rng<=1 | 1 | 1 ;
	int StimDur=500; Independent<<StimDur |"Duration"| 200<=rng<=3000 | 100| 100;
	int BW=5;  Independent<<BW |"Bar Width"| 2<=rng<=12 | 1 | 1 ;
	int EX=120;  Independent<<EX |"Eccentricity"| 20<=rng<=140 | 10 | 20 ;
	int SOA=1; Independent<<SOA |"SOA"| 1<=rng<=8 | 1| 1;
	int Dir=1;  Independent<<Dir |"Motion Direction"| -1<=rng<=1 | 1 | 2 ;
	double Glumi=1.0; Independent<<Glumi|"Green luminance"| 0.0<=rng<=1.0 | 0.05 | 0.05;		
	
	//local parameter---------------------------
	int BI=25;
	int BH=40;
	double Rlumi=1.0; //Red Luminance
	
	int HA=700; //Horizontal Area of Stimulus

	Psychlops::Color Col1, Col2, Col3;
	Psychlops::Rectangle FixRect;
	Psychlops::Rectangle BarRect1[512],BarRect2[512];//Rect for Moving bar
	Psychlops::Rectangle SquareRect1[1024],SquareRect2[1024];//Rect for Flash
	Psychlops::Point The_Center;
	The_Center.set(0.5*DW, 0.5*DH);			
	FixRect.set(5,5).centering(The_Center);

	//Set canvas
	Psychlops::Canvas display(DW,DH,32,DFreq);

	int i, j, iJS, BarNum, Snum, iHA, Right_Edge, Left_Edge;//
	int frame=0, tframe=0, FrameNum, PreFrameNum, StimFrameNum, PostFrameNum, Step;		
	int PreMaskDur=3000, PostMaskDur=1000;
		
	while(!Input::get(Keyboard::esc)){			
		Col1.set(Rlumi, 0.0, 0.0); 
		Col2.set(0.0, Glumi, 0.0);
		Col3.set(Rlumi, Glumi, 0.0);
			
		iJS=BW;
		FrameNum=BI*SOA;
		Snum=(BI-1)/2;
		iHA=HA-((int)HA%(BW*BI*2));
		Right_Edge=DW/2+iHA/2;Left_Edge=DW/2-iHA/2;
		BarNum=(int)iHA/(BW*BI);
			
		frame++;
		frame=frame%(FrameNum);
		Step=(int)frame/SOA;
		
		if(Mode==0){
			display.clear(Color::black);
			display.rect(FixRect,Color::white);

			switch(Stype){
			case 1:
				if(frame%SOA==0){
					for(j=0; j<BarNum; j++){
						if(Dir==1){
							BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);
							BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2+EX).shift(-BI*BW*j, 0);
						}
						else{
							BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);
							BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-BI*BW*j, 0);
						}
						if(Step%2==0){
							if((j%2)==0){display.rect(BarRect1[j],Col1); display.rect(BarRect2[j],Col1);}
							else{display.rect(BarRect1[j],Col2); display.rect(BarRect2[j],Col2);}
						}
						else{
							if((j%2)==0){display.rect(BarRect1[j],Col2); display.rect(BarRect2[j],Col2);}
							else{display.rect(BarRect1[j],Col1); display.rect(BarRect2[j],Col1);}
						}
					}
				}
				break;
				
			case 2:
				if(frame%SOA==0 && Step==0){
					for(j=0; j<BarNum; j++){
						if(Dir==1){
							for(i=0; i<Snum;i++){
								SquareRect1[Snum*j+i].set(BW,BH).centering(Left_Edge,DH/2-EX).shift(BI*BW*j+BW*i, 0);
								SquareRect2[Snum*j+i].set(BW,BH).centering(Right_Edge,DH/2+EX).shift(-BI*BW*j-BW*i, 0);
							}
						}
						else{
							for(i=0; i<Snum;i++){
								SquareRect1[Snum*j+i].set(BW,BH).centering(Left_Edge,DH/2+EX).shift(BI*BW*j+BW*i, 0);
								SquareRect2[Snum*j+i].set(BW,BH).centering(Right_Edge,DH/2-EX).shift(-BI*BW*j-BW*i, 0);
							}
						}
						for(i=0; i<Snum;i++){
							if((j%2)==0 && (i%2)==0){display.rect(SquareRect1[Snum*j+i],Col1); display.rect(SquareRect2[Snum*j+i],Col1);}
							else if((j%2)==0 && (i%2)==1){display.rect(SquareRect1[Snum*j+i],Col2); display.rect(SquareRect2[Snum*j+i],Col2);}
							else if((j%2)==1 && (i%2)==0){display.rect(SquareRect1[Snum*j+i],Col2); display.rect(SquareRect2[Snum*j+i],Col2);}
							else if((j%2)==1 && (i%2)==1){display.rect(SquareRect1[Snum*j+i],Col1); display.rect(SquareRect2[Snum*j+i],Col1);}
						}
					}
				}
				break;
		
			case 3:				
				for(j=0; j<BarNum; j++){
					if(Dir==1){BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);}
					else{BarRect1[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-BI*BW*j, 0);}
				}
				if(frame%SOA==0){
					for(j=0; j<BarNum; j++){
						if(Step%2==0){
							if((j%2)==0){display.rect(BarRect1[j],Col1);}
							else{display.rect(BarRect1[j],Col2);}
						}
						else{
							if((j%2)==0){display.rect(BarRect1[j],Col2);}
							else{display.rect(BarRect1[j],Col1);}
						}
					}
				}
	
				if(frame%SOA==0 && Step==0){
					for(j=0; j<BarNum; j++){
						if(Dir==1){for(i=0; i<Snum;i++){SquareRect1[Snum*j+i].set(BW,BH).centering(Right_Edge,DH/2+EX).shift(-BI*BW*j-BW*i, 0);}}
						else{for(i=0; i<Snum;i++){SquareRect1[Snum*j+i].set(BW,BH).centering(Left_Edge,DH/2+EX).shift(BI*BW*j+BW*i, 0);}}
					}
					for(j=0; j<BarNum; j++){
						for(i=0; i<Snum;i++){
							if((j%2)==0 && (i%2)==0){display.rect(SquareRect1[Snum*j+i],Col1);}
							else if((j%2)==0 && (i%2)==1){display.rect(SquareRect1[Snum*j+i],Col2);}
							else if((j%2)==1 && (i%2)==0){display.rect(SquareRect1[Snum*j+i],Col2);}
							else if((j%2)==1 && (i%2)==1){display.rect(SquareRect1[Snum*j+i],Col1);}
						}
					}
				}
				break;
			}
			display.flip();
		}
		
			
		if(Mode==1){
			if(Input::get(Keyboard::spc)){
				display.clear(Color::black);			
				display.flip();
				
				switch(Stype){
				case 1:
					frame=0;
					PreFrameNum=(int)DFreq*PreMaskDur/1000;
					while(frame<PreFrameNum){
						display.clear(Color::black);			
						display.rect(FixRect,Color::white);
						Step=0;
						for(j=0; j<BarNum; j++){
							if(Dir==1){
								BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);
								BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2+EX).shift(-BI*BW*j, 0);
							}
							else{
								BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);
								BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-BI*BW*j, 0);
							}
							display.rect(BarRect1[j],Col3);
							display.rect(BarRect2[j],Col3);					
						}
						display.flip();
						frame++;
					}
					
					frame=0;Step=0;
					StimFrameNum=(int)DFreq*StimDur/1000;
					while(frame<StimFrameNum){
						display.clear(Color::black);
						display.rect(FixRect,Color::white);
						tframe=frame%(FrameNum);
						Step=(int)tframe/SOA;
						if(tframe%SOA==0){
							for(j=0; j<BarNum; j++){
								if(Dir==1){
									BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);
									BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2+EX).shift(-BI*BW*j, 0);
								}
								else{
									BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);
									BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-BI*BW*j, 0);
								}
								if(Step%2==0){
									if((j%2)==0){display.rect(BarRect1[j],Col1); display.rect(BarRect2[j],Col1);}
									else if((j%2)==1){display.rect(BarRect1[j],Col2); display.rect(BarRect2[j],Col2);}
								}
								else{
									if((j%2)==0){display.rect(BarRect1[j],Col2); display.rect(BarRect2[j],Col2);}
									else if((j%2)==1){display.rect(BarRect1[j],Col1); display.rect(BarRect2[j],Col1);}
								}
							}
						}
						display.flip();
						frame++;
					}

					frame=0;
					PostFrameNum=(int)DFreq*PostMaskDur/1000;
					while(frame<PostFrameNum){
						display.clear(Color::black);			
						display.rect(FixRect,Color::white);
						for(j=0; j<BarNum; j++){
							if(Dir==1){
								BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);
								BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2+EX).shift(-BI*BW*j, 0);
							}
							else{
								BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);
								BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-BI*BW*j, 0);
							}
							display.rect(BarRect1[j],Col3);
							display.rect(BarRect2[j],Col3);					
						}
						display.flip();
						frame++;
					}
				break;
				
				case 2:					
					frame=0;Step=0;
					StimFrameNum=(int)DFreq*StimDur/1000;
					while(frame<StimFrameNum){
						display.clear(Color::black);
						display.rect(FixRect,Color::white);
						tframe=frame%(FrameNum);
						Step=(int)tframe/SOA;
						if(tframe%SOA==0 && Step==0){
							for(j=0; j<BarNum; j++){
								if(Dir==1){
									for(i=0; i<Snum;i++){
										SquareRect1[Snum*j+i].set(BW,BH).centering(Left_Edge,DH/2-EX).shift(BI*BW*j+BW*i, 0);
										SquareRect2[Snum*j+i].set(BW,BH).centering(Right_Edge,DH/2+EX).shift(-BI*BW*j-BW*i, 0);
									}
								}
								else{
									for(i=0; i<Snum;i++){
										SquareRect1[Snum*j+i].set(BW,BH).centering(Left_Edge,DH/2+EX).shift(BI*BW*j+BW*i, 0);
										SquareRect2[Snum*j+i].set(BW,BH).centering(Right_Edge,DH/2-EX).shift(-BI*BW*j-BW*i, 0);
									}
								}
								for(i=0; i<Snum;i++){
									if((j%2)==0 && (i%2)==0){display.rect(SquareRect1[Snum*j+i],Col1); display.rect(SquareRect2[Snum*j+i],Col1);}
									else if((j%2)==0 && (i%2)==1){display.rect(SquareRect1[Snum*j+i],Col2); display.rect(SquareRect2[Snum*j+i],Col2);}
									else if((j%2)==1 && (i%2)==0){display.rect(SquareRect1[Snum*j+i],Col2); display.rect(SquareRect2[Snum*j+i],Col2);}
									else if((j%2)==1 && (i%2)==1){display.rect(SquareRect1[Snum*j+i],Col1); display.rect(SquareRect2[Snum*j+i],Col1);}
								}
							}
						}
						display.flip();
						frame++;
					}
				break;
				
				case 3:
					frame=0;
					PreFrameNum=(int)DFreq*PreMaskDur/1000;
					while(frame<PreFrameNum){
						display.clear(Color::black);			
						display.rect(FixRect,Color::white);
						Step=0;
						for(j=0; j<BarNum; j++){
							if(Dir==1){BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);}
							else{BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);}
							display.rect(BarRect1[j],Col3);
						}
						display.flip();
						frame++;
					}
					
					frame=0;Step=0;
					StimFrameNum=(int)DFreq*StimDur/1000;				
					while(frame<StimFrameNum){
						display.clear(Color::black);
						display.rect(FixRect,Color::white);
						tframe=frame%(FrameNum);
						Step=(int)tframe/SOA;
						if(tframe%SOA==0){
							for(j=0; j<BarNum; j++){
								if(Dir==1){BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);}
								else{BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);}
								if(Step%2==0){
									if((j%2)==0){display.rect(BarRect1[j],Col1);}
									else if((j%2)==1){display.rect(BarRect1[j],Col2);}
								}
								else{
									if((j%2)==0){display.rect(BarRect1[j],Col2);}
									else if((j%2)==1){display.rect(BarRect1[j],Col1);}
								}
							}
						}

						if(tframe%SOA==0 && Step==0){
							for(j=0; j<BarNum; j++){
								if(Dir==1){for(i=0; i<Snum;i++){SquareRect2[Snum*j+i].set(BW,BH).centering(Right_Edge,DH/2+EX).shift(-BI*BW*j-BW*i, 0);}}
								else{for(i=0; i<Snum;i++){SquareRect2[Snum*j+i].set(BW,BH).centering(Right_Edge,DH/2-EX).shift(-BI*BW*j-BW*i, 0);}}
								for(i=0; i<Snum;i++){
									if((j%2)==0 && (i%2)==0){display.rect(SquareRect2[Snum*j+i],Col1);}
									else if((j%2)==0 && (i%2)==1){display.rect(SquareRect2[Snum*j+i],Col2);}
									else if((j%2)==1 && (i%2)==0){display.rect(SquareRect2[Snum*j+i],Col2);}
									else if((j%2)==1 && (i%2)==1){display.rect(SquareRect2[Snum*j+i],Col1);}
								}
							}
						}
						display.flip();
						frame++;
					}

					frame=0;
					PostFrameNum=(int)DFreq*PostMaskDur/1000;
					while(frame<PostFrameNum){
						display.clear(Color::black);			
						display.rect(FixRect,Color::white);
						for(j=0; j<BarNum; j++){
							if(Dir==1){BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);}
							else{BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);}
							display.rect(BarRect1[j],Col3);
						}
						display.flip();
						frame++;
					}
				break;
				
				}
			}
			display.clear(Color::black);			
			display.flip();
		}
	}
}


// **************** Function for Seg demo
void SegDemo(){
	//independent-------------------------------
	Range rng;
	int Stype=1; Independent<<Stype |"Stimulus Type"| 1<=rng<=3 | 1 | 1 ;
	int BI=2;  Independent<<BI |"Bar Interval"| 2<=rng<=6 | 2 | 1 ; 
	int BW=10;  Independent<<BW |"Bar Width"| 3<=rng<=10 | 1 | 1 ;
	int EX=40;  Independent<<EX |"Eccentricity"| 20<=rng<=140 | 10 | 20 ;
	int Dir=1;  Independent<<Dir |"Motion Direction"| -1<=rng<=1 | 1 | 2 ;
	double Glumi=1.0; Independent<<Glumi|"Green Luminance"| 0.0<=rng<=1.0 | 0.05 | 0.05;		
	
	//local parameter---------------------------
	int BH=40; //Bar Height
	int SOA=1;
	double Rlumi=1.0; //Red Luminance

	int HA=650;  //Horizontal Area of Stimulus 
	int VA=600;  //Vertical Area of Stimulus 

	Psychlops::Color Col1, Col2;
	Psychlops::Rectangle FixRect;
	Psychlops::Rectangle BarRect1[512],BarRect2[512];//Rect for Moving bar
	Psychlops::Rectangle CoverRect1,CoverRect2;//Rect for Edge Cover
	Psychlops::Point The_Center;

	//Set canvas
	Psychlops::Canvas display(DW,DH,32,DFreq);

	int j, iJS, iBI, iHA, BarNum, TBW, Right_Edge, Left_Edge;
	int frame=0, FrameNum, Step;
	double Freq;
		
	while(!Input::get(Keyboard::esc)){			
		Col1.set(Rlumi, 0.0, 0.0); 
		Col2.set(0.0, Glumi, 0.0);			
		iJS=BW;
		iBI=BI;
		FrameNum=iBI*SOA*2;
		iHA=HA-((int)HA%(BW*iBI*2));
		BarNum=(int)iHA/(BW*iBI);
		
		Right_Edge=(int)(DW/2+iHA/2);
		Left_Edge=(int)(DW/2-iHA/2);
			
		The_Center.set(0.5*DW, 0.5*DH);			
		FixRect.set(5,5).centering(The_Center);
			
		TBW=(int)DW/2-(iHA/2-BW*iBI*2);//for Edge 
		CoverRect1.set(TBW,VA).centering(TBW/2,DH/2);
		CoverRect2.set(TBW,VA).centering(DW-TBW/2,DH/2);

		frame++;
		frame=frame%(FrameNum);
		Step=(int)frame/SOA;

		display.clear(Color::black);
		display.rect(FixRect,Color::white);
			
		if(Stype==1){				
			for(j=0; j<BarNum; j++){
				if(Dir==1){
					BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(iBI*BW*j, 0);
					BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2+EX).shift(-iBI*BW*j, 0);
				}
				else{
					BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(iBI*BW*j, 0);
					BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-iBI*BW*j, 0);
				}
					
				if((j%2)==0){display.rect(BarRect1[j],Col1);display.rect(BarRect2[j],Col1);}
				else if((j%2)==1){display.rect(BarRect1[j],Col2);display.rect(BarRect2[j],Col2);}
			}
		}
			
		if(Stype==2){
			if(frame%(FrameNum)==0 | frame%(FrameNum)==FrameNum/2){
				for(j=0; j<BarNum; j++){
					if(Dir==1){
						BarRect1[j].set(BW,BH).centering(Left_Edge,DH/2-EX).shift(iBI*BW*j, 0);
						BarRect2[j].set(BW,BH).centering(Right_Edge,DH/2+EX).shift(-iBI*BW*j, 0);
					}
					else{
						BarRect1[j].set(BW,BH).centering(Left_Edge,DH/2+EX).shift(iBI*BW*j, 0);
						BarRect2[j].set(BW,BH).centering(Right_Edge,DH/2-EX).shift(-iBI*BW*j, 0);
					}
				}
			}
							
			if(frame%(FrameNum)==0){
				for(j=0; j<BarNum; j++){
					if((j%2)==0){display.rect(BarRect1[j],Col1);display.rect(BarRect2[j],Col1);}
					else if((j%2)==1){display.rect(BarRect1[j],Col2);display.rect(BarRect2[j],Col2);}
				}
			}
			if(frame%(FrameNum)==FrameNum/2){
				for(j=0; j<BarNum; j++){
					if((j%2)==0){display.rect(BarRect1[j],Col2);display.rect(BarRect2[j],Col2);}
					else if((j%2)==1){display.rect(BarRect1[j],Col1);display.rect(BarRect2[j],Col1);}
				}
			}
		}	
		
		if(Stype==3){
			for(j=0; j<BarNum; j++){
				if(Dir==1){BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(iBI*BW*j, 0);}
				else{BarRect1[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-iBI*BW*j, 0);}
				if((j%2)==0){display.rect(BarRect1[j],Col1);}
				else if((j%2)==1){display.rect(BarRect1[j],Col2);}
			}
				
			if(frame%(FrameNum)==0 | frame%(FrameNum)==FrameNum/2){
				for(j=0; j<BarNum; j++){
					if(Dir==1){BarRect2[j].set(BW,BH).centering(Right_Edge,DH/2+EX).shift(-iBI*BW*j, 0);}
					else{BarRect2[j].set(BW,BH).centering(Left_Edge,DH/2+EX).shift(iBI*BW*j, 0);}
				}
			}
			
			if(frame%(FrameNum)==0){
				for(j=0; j<BarNum; j++){
					if((j%2)==0){display.rect(BarRect2[j],Col1);}
					else if((j%2)==1){display.rect(BarRect2[j],Col2);}
				}
			}
			if(frame%(FrameNum)==FrameNum/2){
					for(j=0; j<BarNum; j++){
					if((j%2)==0){display.rect(BarRect2[j],Col2);}
					else if((j%2)==1){display.rect(BarRect2[j],Col1);}
				}
			}
		}
		Freq=DFreq/(BI*2);
		display.varcheck(Freq, 320, 80, Color::white);
		display.rect(CoverRect1,Color::black);display.rect(CoverRect2,Color::black);
		display.flip();
		}
}


// **************** Function for Amb demo
void AmbDemo(){
	Range rng;
	double PR=1.0;  Independent<<PR |"Path-length Ratio"| 1<=rng<=6 | 2 | 0.5 ;
	int BW=6;  Independent<<BW |"Bar Width"| 3<=rng<=10 | 1 | 1 ;
	int SOA=2; Independent<<SOA |"SOA"| 1<=rng<=10 | 1| 1;
	int EX=80;  Independent<<EX |"Eccentricity"| 10<=rng<=140 | 10 | 20 ;
	int Dir=1;  Independent<<Dir |"Motion Direction"| -1<=rng<=1 | 1 | 2 ;
	double Glumi=1.0; Independent<<Glumi|"Green luminance"| 0.0<=rng<=1.0 | 0.05 | 0.05;		

	//local parameter---------------------------
	int BH=40; //Bar Height
	double Rlumi=1.0; //Red Luminance
	int HA=600;  //Horizontal Area of Stimulus

	Psychlops::Color Col1, Col2;
	Psychlops::Rectangle FixRect,BarRect1[512],BarRect2[512];//
	Psychlops::Point The_Center;
	The_Center.set(0.5*DW, 0.5*DH);			
	FixRect.set(5,5).centering(The_Center);

	//Set canvas
	Psychlops::Canvas display(DW,DH,32,DFreq);

	int j, BI, iHA, iJS, BarNum, Right_Edge, Left_Edge;//
	int frame=0, FrameNum, Step;
		

	while(!Input::get(Keyboard::esc)){			
		Col1.set(Rlumi, 0.0, 0.0); 
		Col2.set(0.0, Glumi, 0.0);			
		BI=PR+1;	
		iJS=BW;
		iHA=HA-(int)(HA%(int)(BW*BI*2));
		FrameNum=(iHA/BW)*SOA;
		BarNum=(int)(iHA/(BW*BI));
		Right_Edge=(int)(DW/2+iHA/2);
		Left_Edge=(int)(DW/2-iHA/2);
			
		frame++;
		frame=frame%(FrameNum);
		Step=(int)frame/SOA;
		
		for(j=0; j<BarNum; j++){
			if(Dir==1){
				BarRect1[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2-EX).shift(BI*BW*j, 0);
				BarRect2[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2+EX).shift(-BI*BW*j, 0);
				if(BarRect1[j].getHcenter()>=Right_Edge){BarRect1[j].shift(-iHA,0);}
				if(BarRect2[j].getHcenter()<=Left_Edge){BarRect2[j].shift(iHA,0);}
			}
			else{
				BarRect1[j].set(BW,BH).centering(Right_Edge-Step*iJS,DH/2-EX).shift(-BI*BW*j, 0);
				BarRect2[j].set(BW,BH).centering(Left_Edge+Step*iJS,DH/2+EX).shift(BI*BW*j, 0);
				if(BarRect1[j].getHcenter()<=Left_Edge){BarRect1[j].shift(iHA,0);}
				if(BarRect2[j].getHcenter()>=Right_Edge){BarRect2[j].shift(-iHA,0);}
			}
		}
	
		display.clear(Color::black);
		display.rect(FixRect,Color::white);
			
		if(frame%SOA==0){
			for(j=0; j<BarNum; j++){
				if(Step%2==0){
					if((j%2)==0){display.rect(BarRect1[j],Col1); display.rect(BarRect2[j],Col1);}
					else if((j%2)==1){display.rect(BarRect1[j],Col2); display.rect(BarRect2[j],Col2);}
				}
				else{
					if((j%2)==0){display.rect(BarRect1[j],Col2); display.rect(BarRect2[j],Col2);}
					else if((j%2)==1){display.rect(BarRect1[j],Col1); display.rect(BarRect2[j],Col1);}
				}
			}
		}
	display.flip();
	}
}





